


/**********************************************************************************************
 *                                                                                            *
 * Ex.3      :  Application Read BCD Touch key Out data to LCD(Use CP-JR51RE2 Board)          *
 *                         (Format:Press key Shift + Key Other                      		  *
 *                                                                                            *
 **********************************************************************************************
 *                                                                                            *
 * Target MCU     : ATMEL AT89C51RE2                                                          *
 *       	      : X-TAL : 18.432 MHz                                                        *
 *                                                                                            *
 * Keil Editor    : uVision3 V3.62C                                                           *
 * Compiler       : Keil C51 (V9.51)                                                          *
 * Create By      : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                      *
 * Last Update    : 08/September/20014                                                        *
 *																				              *
 *																				              *
 * Port Interface :  -- MCU-AT89C51RE2--	  	  	          -- Key Touch PAD 4x4 --         *
 *                                                                                            *
 *                   P1.0(Input)          Connect                 BCD Colum 1                 * 
 *                   P1.1(Input)          Connect                 BCD Colum 2                 *
 *                   P1.2(Input)   	      Connect			      BCD Colum 4                 *
 *                   P1.3(Input)		  Connect				  BCD Colum 8                 *
 *                   P1.4(Input)		  Connect                 T#/R Ststus 1Key            *
 *					 P1.5(Input)	      Connect                 SHIF# Statu 2Key            *
 *																						      *
 *																							  *
 *       LCD     :   Connect 4bit data ;LCD 16x2) by                                          *
 *                   P2.3(output)         Connect         RS                                  *
 *                   P2.2(output)         Connect         R/W                                 *
 *                   P2.1(output)         connect         E                                   *
 *                   P2.4-P2.7(output)    connect         Data 4 bit high                     *
 *                                                                                            *
 *                  																		  *
 *       5V                                                                                   *
 *      --+--                                                                                 *
 *        |                                                                                   *
 *        +-----------------+                                                                 *
 *        |                 |                                                                 *
 *       ---                |                                                                 *
 *       |\|                |                                                                 *
 *    VR |/|<---------------|--+                                                              *
 *   10K ---                |  |P2.3 P2.2 P2.1         P2.4  P2.5   P2.6   P2.7               *
 *        |                 |  |   ^   ^  ^              ^     ^      ^      ^                *
 *        |                 |  |   |   |  |              |     |      |      |                *
 *        +--------------+--|--|---|---|--|--+--+--+--+  |     |      |      |                *
 *      __|__            |  |  |   |   |  |  |  |  |  |  |     |      |      |                *
 *       ---             |  |  |   |   |  |  |  |  |  |  |     |      |      |                *
 *        -             1| 2| 3|  4|  5| 6| 7| 8| 9|10|11|   12|    13|    14|                *
 *                     __|__|__|___|___|__|__|__|__|__|__|___ _|___ __|___ __|_               *
 *                    |  G Vcc Vo RS  R/W E D0 D1 D2 D3 D4    D5      D6    D7 |              *
 *                    |      _____________________________________________     |              *
 *                    |     |                                             |    |              *
 *                    |     |                 Module                      |    |              *
 *                    |     |           LCD 2x16 Charecter                |    |              *  
 *                    |     |_____________________________________________|    |              *
 *                    |                                                        |              *
 *                    |________________________________________________________|              *
 *                                                                                            *                                                                                           *
 *                                                                                            *
 **********************************************************************************************/



#include <at89c51xd2.h>           /* AT89C51xD2    definitions                */
#include <stdio.h>                /* prototype declarations for I/O functions */



//---------------Key Function ---------------

char Check_SHIF(void)   ;
char Check_TR(void)     ;
char RD_KeyCode(void)   ;


//------------------LCD Function ------------------
void init_lcd(void)                   ;				   // Function Initial LCD
void write_ins(unsigned char cmm)     ;				   // Function write Command LCD
void write_data(unsigned char dat)    ;                // Function write data LCD
void delay(unsigned int count)        ; 		  	   // Function Delay Time 
void gotolcd(unsigned char p)         ;                // Function Write position Curser
void EN_LCD()                         ;                // Function Enable Clock

//*************************** Main *************************

 main (void) 
  { 
   char key,k ;
   char message[] = {"ET-TOUCH PAD 4x4"} ;
   char     ms1[] = {" Not!Touch Key! "} ;
   char     ms2[] = {"Touch Key  = "}    ;  
   char     ms3[] = {"Touch Key:SH+"}   ;                            


  
  init_lcd()                              ;	  //Initial LCD 

  gotolcd(0x00)                           ;	  //Start Position data on LCD
  for(k=0;k<16;k++)
    write_data(message[k])                ;	  //Sent data to LCD


   	  
  gotolcd(0x40)                           ;  //Start Position data on LCD
  for(k=0;k<16;k++)                          
 	write_data(ms1[k])                    ;  //Sent Message "Not!Touch Button" to LCD
   	

  while(1)
  {

   if(!Check_TR())                            //Step1: Check  Touch key (Check_TR()=0:Touch,1:release) 
      {
		key  = RD_KeyCode()                ;  //Step2: Read Key Code

        if( key == 0x0F)			          //Step3: Check Touch Key Shift(Touch the 1st Key) is Touch 2 Key
		 {
		    do
			 {
		      if(!Check_SHIF())	              //Step3.1 : Check Touch Key Other(Touch the 2nd Key) by 0:touch,1: not touch
			   {		             
	             key = RD_KeyCode()        ;  //Step 3.2  Read Key Code for Key Shif+Key Other

			     //---------- Step3.3:Program Respond Touch 2key for user(SHIF+Key) ------------
				 
				  switch(key)
		           {
			          case 0x01 :   //Shif+Key#1

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD	
							      write_data('"')                 ; 		     
						          write_data('1')                 ; 
					              write_data('"')                 ; 
				                  
						          break;

					  case 0x02 :   //Shif+Key#2

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD	
								  write_data('"')                 ; 		     
						          write_data('2')                 ; 
					              write_data('"')                 ; 
				                  
						          break;

					  case 0x03 :   //Shif+Key#3

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD			     
						          write_data('"')                 ; 
								  write_data('3')                 ; 
					              write_data('"')                 ; 
				                  
						          break;


			           case 0x04 :   //Shif+Key#4

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD		
								  write_data('"')                 ; 	     
						          write_data('4')                 ; 
					              write_data('"')                 ; 
				                  
						          break;

                       case 0x05 :   //Shif+Key#5

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD		
								  write_data('"')                 ; 	     
						          write_data('5')                 ; 
					              write_data('"')                 ; 
				                  
						          break;


					   case 0x06 :   //Shif+Key#6

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD		
								  write_data('"')                 ; 	 	     
						          write_data('6')                 ; 
					              write_data('"')                 ; 
				                  
						          break;


			        	case 0x07 :   //Shif+Key#7

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD		
								  write_data('"')                 ; 	 	     
						          write_data('7')                 ; 
					              write_data('"')                 ; 
				                  
						          break;


					    case 0x08 :   //Shif+Key#8

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD	
						 		  write_data('"')                 ; 	     
						          write_data('8')                 ; 
					              write_data('"')                 ; 
				                  
						          break;


					    case 0x09 :   //Shif+Key#9

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD		
								  write_data('"')                 ; 	     
						          write_data('9')                 ;
					              write_data('"')                 ; 
				                  
						          break;

				        case 0x00 :   //Shif+Key#0

                                  gotolcd(0x40)                   ;  //Start Position data on LCD
                                  for(k=0;k<13;k++)
                                     write_data(ms3[k])           ;  //Sent data to LCD			 
							      write_data('"')                 ;     
						          write_data('0')                 ; 
					              write_data('"')                 ; 
				                  
						          break;

				  }//switch
                     
				  while(!Check_SHIF()){;} 		   	              ;  //Wait Release 2Key (=1 exit loop)
				  
				  gotolcd(0x40)                                   ;  //Start Position data on LCD
                  for(k=0;k<16;k++)                          
 	                 write_data(ms1[k])                           ;  //Sent Message "Not!Touch Button" to LCD
					 
			    } //if Check Shif
			     										    
			  }while(!Check_TR())                                 ;   //Loop wait Touch the 2nd Key , Exit loop When release Key Shif or 2Key 	  

		 }	//if key == 0x0F
		else                                   //Step4: Check Touch Key Other don't key Shift is Touch 1 Key
		 { 
		   //---------- Step4.1:Program Respond Touch 1 key for user ------------
       
	        switch(key)
		      {
			    case 0x01 :   //Key#1

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD			     
				           write_data('"')                 ;  
						   write_data('1')                 ; 
						   write_data('"')                 ; 
				          
						   break;

		        case 0x02 :   //Key#2

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD			     
				           write_data('"')                 ;  
						   write_data('2')                 ; 
						   write_data('"')                 ; 
				          
						   break;


		         case 0x03 :   //Key#3

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD			     
				           write_data('"')                 ;  
						   write_data('3')                 ; 
						   write_data('"')                 ; 
				        
						   break;

			     case 0x04 :   //Key#4

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD			     
				           write_data('"')                 ;  
						   write_data('4')                 ; 
						   write_data('"')                 ; 
				          
						   break;


			     case 0x05 :  //Key#5

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD			     
				           write_data('"')                 ;  
						   write_data('5')                 ; 
						   write_data('"')                 ; 
				           
						   break;


                 case 0x06 :   //Key#6

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD			     
				           write_data('"')                 ;  
						   write_data('6')                 ; 
						   write_data('"')                 ; 
				         
						   break;

			     case 0x07 :   //Key#7

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD			     
				           write_data('"')                 ;  
						   write_data('7')                 ; 
						   write_data('"')                 ; 
				         
						   break;

				 case 0x08 :   //Key#8

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD			     
				           write_data('"')                 ;  
						   write_data('8')                 ; 
						   write_data('"')                 ; 
				           
						   break;

			     case 0x09 :   //Key#9

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD			     
				           write_data('"')                 ;  
						   write_data('9')                 ; 
						   write_data('"')                 ; 
				          
						   break;

			     case 0x00 :  //Key#0

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD			     
				           write_data('"')                 ;  
						   write_data('0')                 ; 
						   write_data('"')                 ; 
				         
						   break;

			     case 0x0A :  //Key#A(Clear)

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD
			     
				           write_data('"')                 ;  
						   write_data('A')                 ; 
						   write_data('"')                 ; 
				          
						   break;

			     case 0x0B :   //Key#B

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD
				           write_data('"')                 ;  
						   write_data('B')                 ; 
						   write_data('"')                 ; 
				          
						   break;


			     case 0x0C :   //Key#C

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD
				           write_data('"')                 ;  
						   write_data('C')                 ; 
						   write_data('"')                 ; 
				          
						   break;


			     case 0x0D :  //Key#D

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD
			     
				           write_data('"')                 ;  
						   write_data('D')                 ; 
						   write_data('"')                 ; 
				          
						   break;

			     case 0x0E :   //Key#E

                           gotolcd(0x40)                   ;  //Start Position data on LCD
                           for(k=0;k<13;k++)
                             write_data(ms2[k])            ;  //Sent data to LCD
				           write_data('"')                 ;  
						   write_data('E')                 ; 
						   write_data('"')                 ; 
				         
						   break;

			}//Switch
		   
	     while(!Check_TR()){;} 			                   ;   //Wait Release Key (=1 exit loop) 	
		 
        gotolcd(0x40)                                      ;  //Start Position data on LCD
        for(k=0;k<16;k++)                          
          write_data(ms1[k])                               ;  //Sent Message "Not!Touch Button" to LCD
	   } //else
     
	 }	  //if Check_TR
   } 	  //while
  }       //main



/**************************************************************
 **															 ** 
 **                           Sub Program                    **
 **															 **
 **************************************************************/

//---------------------- Check Touch /Release for 2Key -------------------

char Check_SHIF(void)   
{
   char sh   ;
        
	   P1  = 0xFF                ;	 //Set P1 Input
       sh  = P1                  ;   //Read Status Key
	   sh  = sh & 0x20           ;   //Mark bit P1.5 (Statust Press or Release : 2Key)
	
	 if(sh != 0x20)           	     //Check Statue Key
	   return (0)                ;	 //Touch 2Key Return 0 (P1.5=0)
	 else
 	   return (1)                ;	 //Release Key Return 1	(P1.5=1)


}

//---------------------- Check Touch /Release 1Key -------------------

char Check_TR(void)    
 {
   char tr   ;
        
	   P1  = 0xFF                ;	 //Set P1 Input
       tr  = P1                  ;   //Read Status Key
	   tr  = tr & 0x10           ;   //Mark bit P1.4 (Statust Press or Release : 1 Key)
	
	 if(tr != 0x10)           	     //Check Statue Key
	   return (0)                ;	 //Touch Key Return 0 (P1.4=0)
	 else
 	   return (1)                ;	 //Release Key Return 1	(P1.4=1)
 }



//---------- Read BCD Key Code -----------------

 char RD_KeyCode(void) 
  {
	 unsigned int KeyCode                  ;
   
	      P1      =	0xFF                   ;
     KeyCode      = P1                     ;   //Read Key Code
	 KeyCode      = KeyCode & 0x0F         ;   //Mark bit P1.0-P1.3(Key Code 4 bit)
	 return (KeyCode)                      ;
  }





//<<<<<<<<<<<<<<<<<<<---- LCD SUB ---->>>>>>>>>>>>>>>>>>>>>>

//---------- Initial LCD -----------

void init_lcd(void)
 {
  write_ins(0x33)              ;  //CMM Function Set
  write_ins(0x32)              ;  //CMM Function set
  write_ins(0x28)              ;  //CMM Function Set :DL(0)=4bit LCD ,N(1)=2 Line,F(0)= font 5x7 dot

  write_ins(0x0C)              ;  //CMM Display On/OFF :D=1,Display On
  write_ins(0x06)              ;  //CMM Entry :I/D(1)= DD RAM Address Increment,S(0) Cursor Shift
  write_ins(0x01)              ;  //CMM Clear Display
  gotolcd(0x00)                ;  //Start Address 00
 }

 //------- Enable LCD -------
 void EN_LCD()
  {
    P2_1 = 0    ;  //P2.1 =En = 0
	delay(5)    ;
	P2_1 = 1    ;  //P2.1 =En = 1
	delay(5)    ;
 }


//----------- Write Instruction LCD Command ------------

void write_ins(unsigned char cmm)
 {
     
   P2_3 = 0                 ; // P2.3 =RS = 0
   P2_2 = 0                 ; // P2.2 = R/W=0
  
   P2 &= 0x0F               ; // Clear 4 bit High of P2
   P2  |= (cmm & 0xF0)      ; // Clear Command 4 bit Low and Sent Command 4 Bit High to P2
   EN_LCD()                 ; // Enable LCD
   delay(10)                ;
   
   P2 &= 0x0F               ; // Clear 4 bit High of P1 
   P2 |= ((cmm <<4) & 0xF0) ; // Sent Command 4 Bit Low	to P1
   EN_LCD()                 ;
   delay(10)                ;

 }

//----------- Write Data LCD Command ------------


 void write_data(unsigned char dat)
  {
    	   
	P2_3 = 1                 ; // P2.3 = RS  = 1
    P2_2 = 0                 ; // P2.2 = R/W = 0   

	P2 &= 0x0F               ; // Clear 4 bit High of P2 
    P2  |= (dat & 0xF0)      ; // Clear data 4 bit Low and Sent Command 4 Bit High to P2
    EN_LCD()                 ; // Enable LCD
    delay(10)                ;
   

   	P2 &= 0x0F               ; // Clear 4 bit High of P2
    P2 |= ((dat <<4) & 0xF0) ; // Sent Command 4 Bit Low  to P2
	EN_LCD()                 ;
	delay(10)                ;

  }


//------------ Move Cursor LCD ------------

void gotolcd(unsigned char p)
 {
   p |= 0x80    ;
   write_ins(p) ;
 }


//-------- Delay Time Function ---------

void delay(unsigned int count)
{
  int i,j ;
  
  for(i=0;i<count;i++)
    for(j=0;j<count;j++); 
  	
}









